% A 2.2: Downsampling mit/ohne Anti-Aliasing-Filter am Beispiel eines
% Graustufen-Bildes.
% bung Signalverarbeitung, 19.04.2011

clear % leeren des workspace
close all % alle plots schlieen
clc % leeren des comand window

faktor = 10; % Komprimierungsfaktor

% laden des Bildes
f=imread('Aufg2_2_blood1.tif');

% umwandeln des Bildes in Graustufen
f=ind2gray(f,gray(256));
f=f(1:256,1:256);

figure(1)
% ursprngliches Bild
subplot(1,3,1)
imshow(f)
title('Ursprngliches Bild','fontsize',13)

% Downsampling ohne Antialiasing-Filter
subplot(1,3,2)
f1=f(1:faktor:end,1:faktor:end);

% simples Upsampling
pixelMatrixUpsample=kron(f1,uint8(ones(5)));
imshow(pixelMatrixUpsample)

title('Simple Komprimierung','fontsize',13)

% Downsampling mit Antialiasing-Filter
subplot(1,3,3)
f1=imresize(f,1/faktor);

% simples Upsampling
pixelMatrixUpsample=kron(f1,uint8(ones(5)));
imshow(pixelMatrixUpsample)
title('AntiAliasing','fontsize',13)